/**
* \file: IAudioInAdapter.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_IAUDIOINADAPTER_H
#define CARPLAY_IAUDIOINADAPTER_H

#include "IAudioOutAdapter.h"
#include "IConfiguration.h"

namespace adit { namespace carplay
{

/**
 * See IAudioOutAdapter.h for struct Samples and enum AudioFormat definition.
 */

/**
 * Interface provided by CarPlay.
 */
class IAudioInSink
{
public:
    /**
     * Write samples to CarPlay.
     *
     * \param [in] samples      buffer containing audio data
     */
    virtual void Write(const Samples& samples) = 0;

protected:
    /**
     * Default virtual destructor.
     */
    virtual ~IAudioInSink() {};
};

/**
 * Interface to be implemented by adapter.
 *
 * Thread-safety is guaranteed by CarPlay.
 */
class IAudioInAdapter
{
public:
    /**
     * Default virtual descructor.
     */
    virtual ~IAudioInAdapter() {};

    /**
     * Initializes audio pipeline.
     *
     * \param [in] config   configuration
     * \param [in] sink     sink to write audio to
     *
     * \return bool     false: if failed to initialize pipeline
     */
    virtual bool Initialize(const IConfiguration& config, IAudioInSink& sink) = 0;

    /**
     * Prepare audio pipeline.
     *
     * \param [in] format   KHz, Bit and Stereo/Mono settings
     * \param [in] audioType     type of audio
     *
     * \return bool         false: if failed to start pipeline
     *
     * \see Apple specification for audio types.
     */
    virtual bool Prepare(AudioFormatStruct format, const std::string& audioType) = 0;

    /**
     * Set audio pipeline to playing.
     *
     * \return bool         false: if failed to play pipeline
     */
    virtual bool Start() = 0;

    /**
     * Stops audio pipeline.
     */
    virtual void Stop() = 0;
};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_IAUDIOINADAPTER_H */
